/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.gts.config;

import com.cobblemon.mod.common.CobblemonItems;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import org.pokesplash.gts.Gts;
import org.pokesplash.gts.api.file.Versioned;
import org.pokesplash.gts.config.ItemPrices;
import org.pokesplash.gts.config.PokemonAspects;
import org.pokesplash.gts.config.PokemonPrices;
import org.pokesplash.gts.config.Webhook;
import org.pokesplash.gts.oldVersion.ConfigOld;
import org.pokesplash.gts.oldVersion.ItemPricesOld;
import org.pokesplash.gts.util.CodecUtils;
import org.pokesplash.gts.util.Utils;

public class Config
extends Versioned {
    private boolean enablePokemonSales = true;
    private boolean enableItemSales = true;
    private boolean enableAsyncSearches = false;
    private boolean broadcastListings = true;
    private boolean enablePermissionNodes = true;
    private int maxListingsPerPlayer = 8;
    private int listingDuration = 72;
    private Webhook discord;
    private boolean showBreedable;
    private double taxRate = 0.1;
    private double minPrice1IV = 10000.0;
    private double minPrice2IV = 20000.0;
    private double minPrice3IV = 30000.0;
    private double minPrice4IV = 40000.0;
    private double minPrice5IV = 50000.0;
    private double minPrice6IV = 60000.0;
    private double minPriceHA = 50000.0;
    private double minPriceLegendary = 50000.0;
    private double minPriceUltrabeast = 30000.0;
    private double maximumPrice = 1000000.0;
    private List<ItemPrices> customItemPrices = new ArrayList<ItemPrices>();
    private List<JsonElement> bannedItems;
    private List<PokemonPrices> customPokemonPrices;
    private List<PokemonAspects> bannedPokemon;

    public Config() {
        super("2.2");
        this.customItemPrices.add(new ItemPrices());
        this.bannedItems = new ArrayList<JsonElement>();
        this.bannedItems.add(CodecUtils.encodeItem(new class_1799((class_1935)CobblemonItems.LUCKY_EGG)));
        this.customPokemonPrices = new ArrayList<PokemonPrices>();
        this.customPokemonPrices.add(new PokemonPrices());
        this.bannedPokemon = new ArrayList<PokemonAspects>();
        this.bannedPokemon.add(new PokemonAspects());
        this.discord = new Webhook();
        this.showBreedable = false;
    }

    public void init() {
        CompletableFuture<Boolean> futureRead = Utils.readFileAsync("/config/gts/", "config.json", el -> {
            Gson gson = Utils.newGson();
            Versioned version = (Versioned)gson.fromJson(el, Versioned.class);
            if (!version.getVersion().equals("2.2")) {
                Gts.LOGGER.info("GTS Config outdated, updating config...");
                ConfigOld cfgOld = (ConfigOld)gson.fromJson(el, ConfigOld.class);
                this.bannedItems.clear();
                for (String item : cfgOld.getBannedItems()) {
                    class_1799 newBannedItem = Utils.parseItemId(item);
                    this.bannedItems.add(CodecUtils.encodeItem(newBannedItem));
                }
                this.customItemPrices.clear();
                for (ItemPricesOld old : cfgOld.getCustomItemPrices()) {
                    this.customItemPrices.add(new ItemPrices(old));
                }
                this.bannedPokemon.clear();
                for (String pokemon : cfgOld.getBannedPokemon()) {
                    this.bannedPokemon.add(new PokemonAspects(pokemon));
                }
                this.broadcastListings = cfgOld.isBroadcastListings();
                this.maxListingsPerPlayer = cfgOld.getMaxListingsPerPlayer();
                this.listingDuration = cfgOld.getListingDuration();
                this.minPrice1IV = cfgOld.getMinPrice1IV();
                this.minPrice2IV = cfgOld.getMinPrice2IV();
                this.minPrice3IV = cfgOld.getMinPrice3IV();
                this.minPrice4IV = cfgOld.getMinPrice4IV();
                this.minPrice5IV = cfgOld.getMinPrice5IV();
                this.minPrice6IV = cfgOld.getMinPrice6IV();
                this.minPriceHA = cfgOld.getMinPriceHA();
                this.minPriceLegendary = cfgOld.getMinPriceLegendary();
                this.minPriceUltrabeast = cfgOld.getMinPriceUltrabeast();
                this.maximumPrice = cfgOld.getMaximumPrice();
                this.enablePermissionNodes = cfgOld.isEnablePermissionNodes();
                this.discord = cfgOld.getDiscord() == null ? new Webhook() : cfgOld.getDiscord();
                this.showBreedable = cfgOld.isShowBreedable();
                this.write();
                Gts.LOGGER.info("Config successfully updated for GTS!");
            } else {
                Config cfg = (Config)gson.fromJson(el, Config.class);
                this.enablePokemonSales = cfg.isEnablePokemonSales();
                this.enableItemSales = cfg.isEnableItemSales();
                this.enableAsyncSearches = cfg.isEnableAsyncSearches();
                this.broadcastListings = cfg.isBroadcastListings();
                this.maxListingsPerPlayer = cfg.getMaxListingsPerPlayer();
                this.listingDuration = cfg.getListingDuration();
                this.taxRate = cfg.getTaxRate();
                this.minPrice1IV = cfg.getMinPrice1IV();
                this.minPrice2IV = cfg.getMinPrice2IV();
                this.minPrice3IV = cfg.getMinPrice3IV();
                this.minPrice4IV = cfg.getMinPrice4IV();
                this.minPrice5IV = cfg.getMinPrice5IV();
                this.minPrice6IV = cfg.getMinPrice6IV();
                this.minPriceHA = cfg.getMinPriceHA();
                this.minPriceLegendary = cfg.getMinPriceLegendary();
                this.minPriceUltrabeast = cfg.getMinPriceUltrabeast();
                this.maximumPrice = cfg.getMaximumPrice();
                this.enablePermissionNodes = cfg.isEnablePermissionNodes();
                this.discord = cfg.getDiscord() == null ? new Webhook() : cfg.getDiscord();
                this.showBreedable = cfg.isShowBreedable();
                this.bannedItems = cfg.getBannedItems();
                this.customItemPrices = cfg.getCustomItemPrices();
                this.customPokemonPrices = cfg.getCustomPokemonPrices();
                this.bannedPokemon = cfg.getBannedPokemon();
            }
        });
        if (!futureRead.join().booleanValue()) {
            Gts.LOGGER.info("No config.json file found for GTS. Attempting to generate one.");
            CompletableFuture<Boolean> futureWrite = this.write();
            if (!futureWrite.join().booleanValue()) {
                Gts.LOGGER.fatal("Could not write config for GTS.");
            }
            return;
        }
        Gts.LOGGER.info("GTS config file read successfully.");
    }

    public CompletableFuture<Boolean> write() {
        Gson gson = Utils.newGson();
        String data = gson.toJson((Object)this);
        return Utils.writeFileAsync("/config/gts/", "config.json", data);
    }

    public boolean isBroadcastListings() {
        return this.broadcastListings;
    }

    public int getMaxListingsPerPlayer() {
        return this.maxListingsPerPlayer;
    }

    public int getListingDuration() {
        return this.listingDuration;
    }

    public double getMinPrice1IV() {
        return this.minPrice1IV;
    }

    public double getMinPrice2IV() {
        return this.minPrice2IV;
    }

    public double getMinPrice3IV() {
        return this.minPrice3IV;
    }

    public double getMinPrice4IV() {
        return this.minPrice4IV;
    }

    public double getMinPrice5IV() {
        return this.minPrice5IV;
    }

    public double getMinPrice6IV() {
        return this.minPrice6IV;
    }

    public double getMinPriceHA() {
        return this.minPriceHA;
    }

    public double getMaximumPrice() {
        return this.maximumPrice;
    }

    public List<ItemPrices> getCustomItemPrices() {
        return this.customItemPrices;
    }

    public List<JsonElement> getBannedItems() {
        return this.bannedItems;
    }

    public boolean isEnablePermissionNodes() {
        return this.enablePermissionNodes;
    }

    public HashSet<Double> getAllPokemonPrices() {
        HashSet<Double> prices = new HashSet<Double>();
        prices.add(this.minPrice1IV);
        prices.add(this.minPrice2IV);
        prices.add(this.minPrice3IV);
        prices.add(this.minPrice4IV);
        prices.add(this.minPrice5IV);
        prices.add(this.minPrice6IV);
        prices.add(this.minPriceHA);
        return prices;
    }

    public List<PokemonAspects> getBannedPokemon() {
        return this.bannedPokemon;
    }

    public double getMinPriceLegendary() {
        return this.minPriceLegendary;
    }

    public double getMinPriceUltrabeast() {
        return this.minPriceUltrabeast;
    }

    public Webhook getDiscord() {
        return this.discord;
    }

    public boolean isShowBreedable() {
        return this.showBreedable;
    }

    public List<PokemonPrices> getCustomPokemonPrices() {
        return this.customPokemonPrices;
    }

    public double getTaxRate() {
        return this.taxRate;
    }

    public boolean isEnablePokemonSales() {
        return this.enablePokemonSales;
    }

    public boolean isEnableItemSales() {
        return this.enableItemSales;
    }

    public boolean isEnableAsyncSearches() {
        return this.enableAsyncSearches;
    }
}

